module net.BurtonRadons.spyl.valueArray;

private import net.BurtonRadons.spyl.value;

class ArrayValue : Value
{
    Value [] content; /**< Array content. */
    
    ArrayValue sliceParent;
    int sliceStart;
    int sliceEnd = -1; /* -1 for maximum end. */
    ArrayValue [] children;
    
    /** Assign the content; non-copying. */
    this (Value [] content)
    {
        this.content = content;
    }
    
    void insertParent (int index, Value [] array)
    {
        if (sliceParent)
            sliceParent.insertParent (index + sliceStart, array);
        else
        {
            int length = content.length;
            
            content.length = length + array.length;
            for (int c = index + array.length; c < content.length; c ++)
                content [c] = content [c - array.length];
            content [index .. index + array.length] = array;
            content = content [0 .. length];
            
            insertUpdate (index, array.length);
        }
    }
    
    void insert (int index, Value [] array)
    {
        insertParent (index, array);
    }
    
    void insertUpdate (int index, int count)
    {
        if (sliceEnd != -1 && index >= sliceStart && index < sliceEnd)
            sliceEnd += count;
        content = ((Value *) content) [0 .. content.length + count];
        for (int c; c < children.length; c ++)
            children [c].insertUpdate (index - sliceStart, count);
    }
    
    Value getslice (Value min, Value max)
    {
        int imin, imax;
        
        if ((NullValue) min)
            imin = 0;
        else
            imin = ((IntegerValue) min.castTo (IntegerType.create ())).content;
        
        if ((NullValue) max)
            imax = -1;
        else
            imax = ((IntegerValue) max.castTo (IntegerType.create ())).content;

        assert (imin >= 0 && imin < content.length);
        
        if (imax != -1)
            assert (imax >= 0 && imax < content.length && imin <= imax);
            
        ArrayValue child;
        
        child = new ArrayValue (content [imin .. imax < 0 ? content.length : imax]);
        child.sliceParent = this;
        child.sliceStart = imin;
        child.sliceEnd = imax;
        children ~= child;
        return child;
    }
    
    override char [] typeName ()
    {
        return "Array";
    }
    
    override char [] repr ()
    {
        char [] text;
        
        text = "[";
        for (int c; c < content.length; c ++)
        {
            text ~= content [c].toString ();
            if (c < content.length - 1)
                text ~= ", ";
        }
        return text ~ "]";
    }
    
    override Value opAdd (Value other)
    {
        for (int c; c < content.length; c ++)
            content [c] = content [c] + other;
        return this;
    }
    
    override Value opMul (Value other)
    {
        for (int c; c < content.length; c ++)
            content [c] = content [c] * other;
        return this;
    }
    
    Value catArray (Value other)
    {
        return new ArrayValue (content.dup ~ ((ArrayValue) other).content);
    }
    
    override Value opCat (Value other)
    {
        if ((ArrayValue) other)
            return catArray (other);

        Value [] result = new Value [content.length + 1];
        
        result [0 .. content.length] = content;
        result [content.length] = other;
        return new ArrayValue (result);
    }
    
    Value catassArray (Value other)
    {
        insert (content.length, ((ArrayValue) other).content);
        return this;
    }
    
    override Value opCatAssign (Value other)
    {
        if ((ArrayValue) other)
            return catassArray (other);
        
        Value [1] array;
        
        array [0] = other;
        insert (content.length, array);
        return this;
    }
}
